# photo

export interface MediaObjectJson {
thumbnailUrl?: string;
smallImageUrl?: string;
imageUrl?: string;
museum: string; //Mulig denne bør kunne få lov å være undefined ettersom datamodellen ikke garanterer at vi har noen (foreløpig settes da 'unknown' inn, se MuseumNrMapper.findAbbrOrUnknown)
license?: string; //Lisensen for fotografiet
mediaObjectUuid: string;
filename?: string;
title?: string;
motif?: string;
pageNo?: number;
persons?: MediaObjectPerson[];
photographers?: string[];
places?: PublicMediaObjectPlace[];
keywords?: string[];
mediagruppe_id: number;
}

export interface MediaObjectPerson {
personId: number;
name: string;
personRole: string;
sortOrder?: number;
}

export interface PublicMediaObjectPlace {
streetAddress?: string;
county?: string;
municipality?: string;
placeName?: string;
country?: string;
area?: string;
cadastralName?: string;
cadastralNo?: number;
propertyNo?: number;
parish?: string; //TODO: Is this correct?
continent?: string;
region?: string;
}

# Event - archaeology/numismatics/ethnographics

export interface ExportPublicEvent<T> {
eventUuid: EventUuid;
dateFrom?: string;
dateTo?: string;
dateVerbatim?: string;
actors?: PublicOutActorAndRelation[];
places?: PublicPlace[];
attributes?: T;
}

export interface PublicOutActorAndRelation {
role?: string;
date: DateOnly | undefined;
actorName?: string;
actorType?: string;
orderNo?: number;
numisExtras?: NumisActorExtraAttribute; //PersonAttributeNumisExtras;
owc?: EthnicGroupAttributeOwc; //ethno_owc in Attributes-table
muvExtras?: MuvPersonAttributeExtras;
}

export interface NumisActorExtraAttribute {
culturePlaceUuid?: Uuid;
culturePlace?: string;
fromYear?: number;
toYear?: number;
comment?: string;
}

export interface EthnicGroupAttributeOwc {
owcCode?: string[];
}

export interface MuvPersonAttributeExtras {
description?: string;
}

export type PublicPlace =
| NewInOutPlace
| PublicAdmPlace
| PublicEthnicPlace
| PublicNumismaticPlace;

export interface PublicAdmPlace {
county?: string;
municipality?: string;
cadastralName?: string;
cadastralNo?: number;
properties?: PublicProperty[];
}

export interface PublicProperty {
propertyName?: string;
propertyNo?: number;
}

export interface PublicNumismaticPlace {
placeName: string;
fullPath?: NumisPlaceFullPath;
attributes?: NumisPlaceAttribute;
}

export interface NumisPlaceFullPath {
continent?: string; //verdensdel?: string;
country?: string; //land?: string;
area?: string; //omraade?: string;
producer?: string; //myntsted?: string;
county?: string; // fylke
locality?: string; //lokalitet?: string;
}

export interface NumisPlaceAttribute {
fromYear?: number;
toYear?: number;
comment?: string;
}

export interface PublicEthnicPlace {
continent?: string;
region?: string;
country?: string;
district?: string;
area?: string;
location?: string;
owcCode?: string[];
}

# Thing - archaeology

export interface PublicArchaeology {
thingUuid: MuseumObjectUuid;
oldThingUuid: MuseumObjectUuid; // Gammel uuid for objektet/artefaktet (før arkeologiske gjenstander fikk nye uuids), kan være lik thingUuid. Kun relevant for VTM?
museum: string;
collectionType: string;
termNo?: string; // same as artefactTerms concatinated, a generic attributeName for all collections
museumNo?: string;
museumNoAsNumber?: number;
museumSubNo?: string;
museumSubNoAsNumber?: number;
museumSubNo2?: string;
siteFindNo?: string;
findsEvent?: ExportPublicEvent<PublicArchaeologyFindsAttributes>;
classification?: PublicArchaeologyClassification;
materials?: PublicArchaeologyMaterial[];
measurement?: PublicArchaeologyMeasurement;
contextLayer?: Contextlayer;
thumbnailUrl?: string;
smallImageUrl?: string;
documentUrls?: string[];
updatedDate?: string;
objectAttributes?: PublicArchaeologyObjectAttributes;
}

export interface PublicArchaeologyObjectAttributes {
artefactCount?: number;
burnt?: number;
colour?: string[];
cortex?: number;
dating?: string;
decoration?: string;
draft_assessment?: string;
draft_description?: string;
draft_seqNo?: number;
fragmentCount?: string;
grinded?: boolean;
hasDecoration?: boolean;
literatureReferences?: PublicArchaeoLiterature[];
retouch?: boolean;
technique?: string;
uncertainty?: string;
usewear?: boolean;
waterRolled?: number;
}

export interface PublicArchaeologyClassification {
artefact?: string;
form?: string;
artefactVariant?: string;
description?: string;
partOfArtefact?: string;
}

export interface PublicArchaeologyMaterial {
material?: string;
spesMaterial?: string;
sorting?: number;
}

export interface PublicArchaeologyMeasurement {
diameter?: NumberWithPrecision;
height?: NumberWithPrecision;
largestMeasurement?: NumberWithPrecision;
length?: NumberWithPrecision;
other?: string;
thickness?: NumberWithPrecision;
weightAsText?: string;
width?: NumberWithPrecision;
};

export interface PublicArchaeoLiterature {
author?: string;
doi?: string;
title: string;
year?: string;
}

# Find - archaeology

export interface PublicArchaeologyFindsAttributes {
derivedFrom?: string;
findCategories?: string[];
findsInformation?: string;
geoReferenceComment?: string;
geoReferences?: PublicCoordinates[];
location?: string;
locationAndMonuments?: LocationAndMonument[];
periods?: string[];
reports?: Report[];
yearOfFinds?: string;
}

export interface Report {
Year?: number;
author?: string;
title: string;
doi?: string;
archiveNo?: string;
}

export interface LocationAndMonument {
locationId: number;
monumentId?: number;
}

export interface PublicCoordinates {
precision?: string;
projection?: string;
utmNorth?: string;
utmEast?: string;
height?: string;
latitude?: string;
longitude?: string;
}

# Context - archaeology

export interface Contextlayer {
contextUuid?: Uuid;
attributes?: ContextAttributes;
}

export interface ContextAttributes {
context1BRM?: string;
context2BRM?: string;
contextId?: string;
excavationSite?: string;
geoReferences?: CoordinatesForContext;
mechanicalLayer?: string;
phase?: string;
quadrant?: string;
square?: string;
stratigraphicalLayer?: string;
structureNo?: string;
structureType?: string;
};

export interface CoordinatesForContext {
method?: string;
projection?: string;
x?: string;
y?: string;
z?: string;
}

# Thing - ethnography

export interface PublicEthnography {
thingUuid: MuseumObjectUuid;
museum: string;
collectionType: string;
termNo?: string; // same as artefactTerms concatinated, a generic attributeName for all collections
museumNo?: string;
museumSubNo?: string;
classification?: EthnoClassification;
material?: EtnoMaterial;
measurements?: EthnoMeasurement;
collections?: string[];
provenance?: Provenance;
thumbnailUrl?: string;
smallImageUrl?: string;
updatedDate?: string;
otherNumbers?: OtherNumbers[];
objectAttributes?: EthnographicObjectAttributes;
catalogCardUrls?: string[];
}

export interface EthnographicObjectAttributes{
colours?: (string)[];
colourSlip?: string;
contextAndSource?: string;
draft_assessment?: string;
draft_description?: string;
draft_seqNo?: number;
epochStyle?: (string)[];
inscription?: string;
munsell?: string;
munsellslip?: string;
quantity?: string;
religion?: string;
};

export interface EthnoClassification {
artefactTerms?: string[];
artefactTypes?: string[];
artefactVariant?: string;
languageOrEmic?: LanguageOrEmic[];
description?: string;
ocm?: Ocm[];
}

export interface EthnoMeasurement {
diameter?: number;
height?: number;
length?: number;
other?: string;
thickness?: number;
weight?: number;
width?: number;
}

export interface EthnoMaterialSpec {
typeOfMaterial?: string;
mainMaterial?: string;
}

export interface EtnoMaterial {
materials?: EthnoMaterialSpec[];
languageOrEmic?: LanguageOrEmic[];
}

export interface LanguageOrEmic {
language: string;
emicText?: string; // emic for artefactTerms or mainMaterial
emicTypeText?: string; // emic for artefactTypes or typeOfMaterial
emic?: boolean;
emicDescription?: string;
languageComment?: string;
}

export interface Ocm {
ocmCode?: string;
ocmText: string;
}

export interface OtherNumbers {
no: string;
typeOfNo?: string;
}

export interface Provenance {
production?: EthnicEvent;
typeOfUse?: EthnicEvent; // etnografi har kun en
usedAs?: EthnicEvent; // etnografi har kun en
acquisitions?: EthnicEvent[];
muvTypeOfUse?: EthnicEvent[]; // MUVTypeOfUse kan ha flere enn
muvUsedAs?: EthnicEvent[]; // MUVUsedAs kan ha flere enn
}

export interface EthnicEvent {
eventId?: number;
eventType?: string;
archiveNo?: string;
place?: PublicEthnicPlace[];
actors?: PublicOutActorAndRelation[];
ethnicGroups?: PublicOutActorAndRelation[];
additionalInfo?: string;
date?: string;
}

export interface PublicEthnicPlace {
continent?: string;
region?: string;
country?: string;
district?: string;
area?: string;
location?: string;
owcCode?: string[];
}

# Thing - numismatic

export interface PublicNumismatic {
thingUuid?: string;
museum: string;
collectionType: string;
museumNo?: string;
museumSubNo?: string;
museumSubNo2?: string;
findsEvent: ExportPublicEvent<PublicNumismaticFindsAttributes>;
classification?: PublicNumismaticClassificationAttributes;
objectAttribute?: PublicNumismaticObjectAttributes;
measurements?: PublicNumismaticMeasurementAttributes;
acquisition?: PublicNumismaticAcquistionAttributes;
oldNumbers?: OldNumberAssignmentEventAttributes;
productionEvent?: ExportPublicEvent<PublicNumismaticProductionAttributes>;
defaultPhotoId?: number;
defaultPhotoUuid?: string;
photos?: NumisPhoto[];
materials?: PublicNumismaticMaterialAttributes[];
updatedDate?: string;
}

export interface PublicNumismaticFindsAttributes extends EventAttributes {
findCategory?: string;
locationId?: number;
};

export interface PublicNumismaticAcquistionAttributes {
acquisitionNo?: string;
provenance?: string;
umkNo?: string;
}

export interface PublicNumismaticProductionAttributes {
dieNumber?: string;
typeRemarks?: string;
workshop?: string;
productionMethods?: string[];
signature?: string;
}

export interface PublicNumismaticObjectAttributes {
packagingDescription?: string;;
packagingNumber?: string;
legend?: string;
englishKeyword?: string;
inscriptionComments?: string;
mounting?: string;
motifAdverse?: string;
inscriptionAdverse?: string;
mountingOther?: string;
quantity?: number;
catalogue?: string;
motifReverse?: string;
inscriptionReverse?: string;
bandColor?: string;
subCollectionText?: string;
}

export interface PublicNumismaticClassificationAttributes {
denomination?: string;
denominationCulturePlaceUuid?: string;
denominationFromYear?: number;
denominationPlace?: string;
denominationToYear?: number;
remarks?: string;
shape?: string;
theme?: string;
internalNote?: string;
note?: string;
shapeOther?: string;
artefactType?: string;
category?: string;
characterization?: string;
}

export interface PublicNumismaticMaterialAttributes {
name: string;
englishName?: string;
symbol?: string;
}

export interface PublicNumismaticMeasurementAttributes {
diameter?: NumberWithPrecision_EtAuto;
height?: NumberWithPrecision_EtAuto;
other?: string;
weight?: NumberWithPrecision_EtAuto;
width?: NumberWithPrecision_EtAuto;
}

export interface NumberWithPrecision_EtAuto {
value: number;
precision?: number;
}

export interface NumisPhoto {
photoId: number;
photoUuid?: string;
}
